<?php
/* --------------------------------------------------------------
   ParcelService.php 2020-04-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\ParcelService\Interfaces;

use Gambio\Core\Language\LanguageId;
use JsonSerializable;

/**
 * Interface ParcelService
 *
 * @package Gambio\Admin\ParcelService\Interfaces
 */
interface ParcelService extends JsonSerializable
{
    /**
     * Returns the ID.
     *
     * @return int|null
     */
    public function id(): ?int;
    
    
    /**
     * Returns the name.
     *
     * @return string
     */
    public function name(): string;
    
    
    /**
     * Returns the "is default" state.
     *
     * @return bool
     */
    public function isDefault(): bool;
    
    
    /**
     * Returns the url.
     *
     * @param LanguageId $languageId
     *
     * @return string
     */
    public function url(LanguageId $languageId): string;
    
    
    /**
     * Returns the comment.
     *
     * @param LanguageId $languageId
     *
     * @return string
     */
    public function comment(LanguageId $languageId): string;
    
}